package furny.swing.admin;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

import furny.entities.Furniture;
import furny.furndb.FurnDBManager;
import furny.swing.admin.viewer.IFurnitureViewer;

/**
 * Popup menu for furnitures. Provides actions for furniture handling.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
@SuppressWarnings("serial")
public class FurnitureLabelPopupMenu extends JPopupMenu {
  private final Furniture furniture;
  private final IFurnitureViewer viewer;

  /**
   * Instantiates a new furniture label popup menu.
   * 
   * @param viewer
   *          the viewer
   * @param furniture
   *          the furniture
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public FurnitureLabelPopupMenu(final IFurnitureViewer viewer,
      final Furniture furniture) {
    this.viewer = viewer;
    this.furniture = furniture;

    add(new ActionShow());

    addSeparator();

    add(new ActionDelete());
  }

  /**
   * Action to show the furniture in the viewer.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  private class ActionShow extends AbstractAction {

    /**
     * Instantiates a new action show.
     * 
     * @since 12.08.2012
     * @author Stephan Dreyer
     */
    public ActionShow() {
      super("Show in model viewer");
      putValue(SHORT_DESCRIPTION, "Show this furniture in the 3D model viewer");
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
      viewer.setFurniture(furniture);
    }
  }

  /**
   * Action to delete the furniture.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  private class ActionDelete extends AbstractAction {

    /**
     * Instantiates a new action delete.
     * 
     * @since 12.08.2012
     * @author Stephan Dreyer
     */
    public ActionDelete() {
      super("Delete");
      putValue(SHORT_DESCRIPTION, "Delete this furniture");
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
      final int n = JOptionPane.showConfirmDialog(null,
          "Are you sure to delete furniture \"" + furniture.getName() + "\" ("
              + furniture.getId() + ")?", "Delete Furniture",
          JOptionPane.YES_NO_OPTION, JOptionPane.PLAIN_MESSAGE);

      if (n == JOptionPane.YES_OPTION) {
        FurnDBManager.getInstance().deleteFurniture(furniture.getId());
      }
    }
  }
}
